{
  lib,
  stdenv,
  fetchFromGitHub,
  autoreconfHook,
  pkg-config,
  glib,
  ncurses,
  libcap_ng,
  enableSystemd ? lib.meta.availableOn stdenv.hostPlatform systemdMinimal,
  systemdMinimal,
}:

stdenv.mkDerivation rec {
  pname = "irqbalance";
  version = "1.9.4-unstable-2025-06-10";

  src = fetchFromGitHub {
    owner = "Irqbalance";
    repo = "irqbalance";
    rev = "8e8945e5092caf45605dfb1e66165e2eb9ec1f56";
    sha256 = "sha256-DSXFJZ0MyI10ZVFcGY0Sx1kye1ALMeG41nmyqbfO8vQ=";
  };

  nativeBuildInputs = [
    autoreconfHook
    pkg-config
  ];
  buildInputs = [
    glib
    ncurses
    libcap_ng
  ]
  ++ (lib.optionals enableSystemd [
    systemdMinimal
  ]);

  configureFlags = lib.optionals enableSystemd [
    "--with-systemd"
    "systemdsystemunitdir=$$out/lib/systemd/system"
  ];

  postInstall = ''
    # Systemd service
    sed -i "/^EnvironmentFile=/d" "$out/lib/systemd/system/irqbalance.service"
    substituteInPlace "$out/lib/systemd/system/irqbalance.service" \
      --replace-fail /usr/sbin/irqbalance "$out/bin/irqbalance --journal" \
      --replace-fail ' $IRQBALANCE_ARGS' ""
  '';

  meta = {
    homepage = "https://github.com/Irqbalance/irqbalance";
    changelog = lib.strings.optionalString (
      !lib.strings.hasInfix "-unstable-" version
    ) "https://github.com/Irqbalance/irqbalance/releases/tag/v${version}";
    description = "Daemon to help balance the cpu load generated by interrupts across all of a systems cpus";
    license = lib.licenses.gpl2Only;
    platforms = lib.platforms.linux;
    maintainers = with lib.maintainers; [ moni ];
  };
}
