{
  lib,
  buildGoModule,
  fetchFromGitHub,
}:

buildGoModule rec {
  pname = "go-exploitdb";
  version = "0.6.1";

  src = fetchFromGitHub {
    owner = "vulsio";
    repo = "go-exploitdb";
    tag = "v${version}";
    hash = "sha256-2ldb+u5C9BdDOXzyuDxHgJ65Iot/+E4KCC6sm8nHv0U=";
  };

  vendorHash = "sha256-GEMwuVTHamNX/A6Btslp4pmYJd4lylrjw7w/0Q/wKF8=";

  ldflags = [
    "-s"
    "-w"
    "-X=github.com/vulsio/go-exploitdb/config.Version=${version}"
  ];

  meta = {
    description = "Tool for searching Exploits from Exploit Databases, etc";
    mainProgram = "go-exploitdb";
    homepage = "https://github.com/vulsio/go-exploitdb";
    changelog = "https://github.com/vulsio/go-exploitdb/releases/tag/v${version}";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ fab ];
  };
}
