{
  lib,
  python3Packages,
  fetchFromGitHub,

  # dependencies
  cmake-format,

  # tests
  cmake,
  versionCheckHook,
}:

python3Packages.buildPythonApplication rec {
  pname = "cmake-language-server";
  version = "0.1.11";
  pyproject = true;

  src = fetchFromGitHub {
    owner = "regen100";
    repo = "cmake-language-server";
    tag = "v${version}";
    hash = "sha256-QxknG5NFYky6ZSjiIugLfHT4gXsyTBVbMMeULhQsmdk=";
  };

  # Test timeouts occasionally cause the build to fail
  postPatch = ''
    substituteInPlace tests/test_server.py \
      --replace-fail \
        "CALL_TIMEOUT = 2" \
        "CALL_TIMEOUT = 10"
  '';

  build-system = with python3Packages; [
    pdm-backend
  ];
  dontUseCmakeConfigure = true;

  dependencies = with python3Packages; [
    pygls
  ];

  pythonImportsCheck = [ "cmake_language_server" ];

  nativeCheckInputs = [
    cmake
    cmake-format
  ]
  ++ (with python3Packages; [
    pytest-datadir
    pytestCheckHook
    versionCheckHook
  ]);
  versionCheckProgramArg = "--version";

  # version.py generated by pdm, no idea why it's not present in test phase
  # https://github.com/regen100/cmake-language-server/blob/v0.1.11/pyproject.toml#L35-L36
  preCheck = ''
    echo "__version__ = \"$PDM_BUILD_SCM_VERSION\"" > cmake_language_server/version.py
  '';

  meta = {
    description = "CMake LSP Implementation";
    homepage = "https://github.com/regen100/cmake-language-server";
    changelog = "https://github.com/regen100/cmake-language-server/releases/tag/${src.tag}";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ kira-bruneau ];
    mainProgram = "cmake-language-server";
  };
}
