{
  fetchFromGitHub,
  lib,
  swift,
  swiftPackages,
  swiftpm,
  swiftpm2nix,
}:
let
  # Nix dir generated by running `swiftpm2nix` in the upstream project
  generated = swiftpm2nix.helpers ./nix;
in
swiftPackages.stdenv.mkDerivation rec {
  pname = "autokbisw";
  version = "2.0.1";
  src = fetchFromGitHub {
    owner = "ohueter";
    repo = "autokbisw";
    tag = version;
    hash = "sha256-xNXXgDLWW8pdik3STmhpZATf9REd+8IGeoX/oxGg4vc=";
  };
  nativeBuildInputs = [
    swift
    swiftpm
  ];
  configurePhase = generated.configure;
  installPhase = ''
    runHook preInstall

    mkdir -p $out/bin
    cp $(swiftpmBinPath)/autokbisw $out/bin/

    runHook postInstall
  '';

  meta = {
    description = "Automatic keyboard input language switching for macOS";
    homepage = "https://github.com/ohueter/autokbisw";
    changelog = "https://github.com/ohueter/autokbisw/releases/tag/${version}";
    license = lib.licenses.asl20;
    mainProgram = "autokbisw";
    maintainers = with lib.maintainers; [ craigf ];
    platforms = lib.platforms.darwin;
  };
}
