# Nixpkgs 25.05 (2025.05/23) {#sec-nixpkgs-release-25.05}

## Highlights {#sec-nixpkgs-release-25.05-highlights}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- **This release of Nixpkgs requires macOS Big Sur 11.3 or newer, as announced in the 24.11 release notes.**
  We cannot guarantee that packages will continue to work on older versions of macOS.
  Future Nixpkgs releases will only support [macOS versions supported by Apple](https://endoflife.date/macos); this means that **Nixpkgs 25.11 will require macOS Sonoma 14 or newer**.
  Users on old macOS versions should consider upgrading to a supported version (potentially using [OpenCore Legacy Patcher](https://dortania.github.io/OpenCore-Legacy-Patcher/) for old hardware) or installing NixOS.
  If neither of those options are viable and you require new versions of software, [MacPorts](https://www.macports.org/) supports versions back to Mac OS X Snow Leopard 10.6.

- The default kernel package has been updated from 6.6 to 6.12. All supported kernels remain available.

- GCC has been updated from GCC 13 to GCC 14.
  This introduces some backwards‐incompatible changes; see the [upstream porting guide](https://gcc.gnu.org/gcc-14/porting_to.html) for details.

- The default GHC version has been updated from 9.6 to 9.8.
  `haskellPackages` also uses Stackage LTS 23 (instead of LTS 22) as a baseline.
  We aim to remove the old GHC versions 8.10, 9.0 and 9.2 in the next release in accordance with [the new GHC deprecation policy](https://discourse.nixos.org/t/nixpkgs-ghc-deprecation-policy-user-feedback-necessary/64153).

- LLVM has been updated from LLVM 16 (on Darwin) and LLVM 18 (on other platforms) to LLVM 19.
  This introduces some backwards‐incompatible changes; see the [upstream release notes](https://releases.llvm.org/) for details.

- The Factor programming language packages were reworked. `factor-lang-scope` is now named `factorPackages` and provides a `buildFactorApplication` function to deploy Factor programs as binaries. It has also received proper documentation in the Nixpkgs manual.

- The packaging of Mesa graphics drivers has been significantly reworked, in particular:
  - Applications linked against different Mesa versions than installed on the system should now work correctly going forward (however, applications against older Mesa, e.g. from Nixpkgs releases before 25.05, remain broken)
  - Packages that used to depend on Mesa for libgbm or libdri should use `libgbm` or `dri-pkgconfig-stub` as inputs, respectively

- GNU Taler has been updated to version 1.0.
  This marks a significant milestone as the GNU Taler payment system is now available in Swiss Francs for individuals and businesses in Switzerland.
  For more details, see the [upstream release notes](https://www.taler.net/en/news/2025-01.html).

- OpenSSH has been updated from 9.9p2 to 10.0p2, dropping support for DSA keys and adding a new `ssh-auth` binary to handle user authentication in a different address space from unauthenticated sessions. See the [full changelog](https://www.openwall.com/lists/oss-security/2025/04/09/1) for more details.

- Emacs has been updated to 30.1.
  This introduces some backwards‐incompatible changes; see the NEWS for details.
  NEWS can be viewed from Emacs by typing `C-h n`, or by clicking `Help->Emacs News` from the menu bar.
  It can also be browsed [online](https://git.savannah.gnu.org/cgit/emacs.git/tree/etc/NEWS?h=emacs-30).

- The `intel` video driver for X.org (from the xf86-video-intel package, which was previously removed because it was non-functional) has been fixed and the driver has been re-introduced.

- The default openexr version has been updated to 3.2.4.

- The default PHP version has been updated to 8.4.

- The default Erlang OTP version has been updated to 27.

- The default Elixir version has been updated to 1.18.

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

## Backward Incompatibilities {#sec-nixpkgs-release-25.05-incompatibilities}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- `apptainer` and `singularity` deprecate the workaround of overriding `vendorHash` and related attributes via `<pkg>.override`,
  in favour of the unified overriding of the same group of attributes via `<pkg>.overrideAttrs`.
  The compatibility layer will be removed in future releases.

- `squid` has been updated to version 7, this release includes multiple breaking changes, like ESI removal.
  For more information, [check the release notes](https://github.com/squid-cache/squid/releases/tag/SQUID_7_0_1).

- `postgresql` and `libpq` don't provide `pg_config` by default anymore. Instead, `pg_config` is available via `postgresql.pg_config` or `libpq.pg_config`. This allowed implementing it as a shell script, which can be built for both the build and host systems when cross-compiling. If your build fails to find `pg_config`, add `postgresql.pg_config` or `libpq.pg_config` to `nativeBuildInputs`.

- The [`no-broken-symlinks` hook](https://nixos.org/manual/nixpkgs/unstable/#no-broken-symlinks.sh) was added to catch builds containing dangling or reflexive symlinks, as these are indicative of problems with packaging.
  The hook can be disabled by providing `dontCheckForBrokenSymlinks = true;` as an argument to `mkDerivation`.
  For more information, [check the docs](https://nixos.org/manual/nixpkgs/unstable/#no-broken-symlinks.sh) or [see this PR](https://github.com/NixOS/nixpkgs/pull/370750).

- `gkraken` has been removed. The recommended alternative is `coolercontrol`.

- `opensmtpd-extras` has been deprecated by upstream and is not compatible with
  OpenSMTPD 7.6.0 or later. The package has been removed in favor of a set of new
  `opensmtpd-table-*` packages.

- `postsrsd` upgraded to `>= 2.0.0`, with some different behaviors and
  configuration settings. Notably, it now defaults to listening on a socket
  rather than a port. See [Migrating from version 1.x](https://github.com/roehling/postsrsd/blob/2.0.10/README.rst#migrating-from-version-1x) and [Postfix Setup](https://github.com/roehling/postsrsd?tab=readme-ov-file#postfix-setup) for details.

- `renovate` was updated to v39. See the [upstream release notes](https://github.com/renovatebot/renovate/releases/tag/39.0.0) for breaking changes.
  Like upstream's Docker images, renovate now runs on NodeJS 22.

- The handwritten `perlPackages.SearchXapian` bindings have been dropped in favor of the (mostly compatible)
  `perlPackages.Xapian`.

- `varnish` was updated from 7.5.0 to 7.7.0, see [Varnish 7.6.0 upgrade guide](https://varnish-cache.org/docs/7.6/whats-new/upgrading-7.6.html) and
[Varnish 7.7.0 upgrade guide](https://varnish-cache.org/docs/7.7/whats-new/upgrading-7.7.html#whatsnew-upgrading-7-7).

- The `config` triple for `aarch64-darwin` has been changed from `aarch64-apple-darwin` to `arm64-apple-darwin` to match the Apple toolchain and LLVM’s expectations.

- The `electron` packages will now provide their headers (available via `electron.headers`) in extracted form instead of in a tarball.

- The udev rules of the `libjaylink` package require users to be in the `jlink` instead of `plugdev` group now, since the `plugdev` group is very uncommon for NixOS. Alternatively, access is granted to seat sessions.

- The `ephemeral` package was removed due to upstream archival in early 2022.

- The `gotenberg` package has been updated to 8.16.0, which brings breaking changes to the configuration from version 8.13.0. See the [upstream release notes](https://github.com/gotenberg/gotenberg/releases/tag/v8.13.0) for that release to get all the details.

- `zammad` has had its support for MySQL removed, since it was never working correctly and is now deprecated upstream. Check the [migration guide](https://docs.zammad.org/en/latest/appendix/migrate-to-postgresql.html) for how to convert your database to PostgreSQL.

- The `vocal` package was removed due to upstream archival. The upstream developer suggests using `gnome-podcasts` or `kasts` instead.

- `timescaledb` requires manual upgrade steps.
    After you run ALTER EXTENSION, you must run [this SQL script](https://github.com/timescale/timescaledb-extras/blob/master/utils/2.15.X-fix_hypertable_foreign_keys.sql). For more details, see the following pull requests [#6797](https://github.com/timescale/timescaledb/pull/6797).
    PostgreSQL 13 is no longer supported in TimescaleDB v2.16.

- `paperless-ngx` has been updated to minor version 2.15 which switched the web server from Gunicorn to Granian. If you set Gunicorn specific envs (usually contain GUNICORN) they must be updated.

- [testers.shellcheck](https://nixos.org/manual/nixpkgs/unstable/#tester-shellcheck) now warns when `name` is not provided.
  The `name` argument will become mandatory in a future release.

- `tauon` 7.9.0+ when launched for the first time, migrates its database to a new schema that is not backwards compatible. Older versions will refuse to start at all with that database afterwards. If you need to still use older tauon versions, make sure to back up `~/.local/share/TauonMusicBox`.

- `aws-workspaces` has dropped support for PCoiP networking.

- [GIMP 3.0](https://www.gimp.org/news/2025/03/16/gimp-3-0-released/) available as `gimp3`.

- `grafana-agent` and `services.grafana-agent` have been removed in favor of
  Grafana Alloy (`grafana-alloy` and `services.alloy`), as they depend on an EOL compiler version
  and will become EOL during the 25.05 lifecycle.
  Grafana recommends migrating to `grafana-alloy` (`services.alloy`).
  See https://grafana.com/docs/alloy/latest/set-up/migrate/ for details.

- `slskd` has been updated to v0.22.3, which includes breaking changes to `script` integrations. Please review the [changelog](https://github.com/slskd/slskd/releases/tag/0.22.3)
  and the accompanying [pull request](https://github.com/slskd/slskd/pull/1292).

- `forgejo` and `forgejo-lts` have been updated to v11.
  See upstreams [release blog post](https://forgejo.org/2025-04-release-v11-0/) for more information.

- `unifi` has been updated to v9.1.
  This version should be backward compatible with v8.x, however as a result, `unifi8` package has been removed.

- `xdragon` package has been renamed to `dragon-drop`.
  `xdragon` is an alias to `dragon-drop` and the package still provides `bin/xdragon`.
  `bin/dragon` is no longer supplied.

- `python3Packages.bpycv` has been removed due to being incompatible with Blender 4 and unmaintained.

- `python3Packages.jaeger-client` was removed because it was deprecated upstream. [OpenTelemetry](https://opentelemetry.io) is the recommended replacement.

- `rocmPackages_6` has been updated to ROCm 6.3.

- `rocmPackages_5` has been removed.

- `rocmPackages.rocm-thunk` has been removed and its functionality has been integrated with the ROCm CLR. Use `rocmPackages.clr` instead.

- `rocmPackages.clang-ocl` has been removed. [It was deprecated by AMD in 2023.](https://github.com/ROCm/clang-ocl)

- `nodePackages.meshcommander` has been removed, as the package was deprecated by Intel.

- The default version of `z3` has been updated from 4.8 to 4.13. There are still a few packages that need specific older versions; those will continue to be maintained as long as other packages depend on them but may be removed in the future.

- The `nixLog*` family of functions made available through the standard environment have been rewritten to prefix messages with both the debug level and the function name of the caller.
  The `nixLog` function, which logs unconditionally, was also re-introduced and modified to prefix messages with the function name of the caller.
  For more information, [see this PR](https://github.com/NixOS/nixpkgs/pull/370742).

- `postgresql`'s `pythonSupport` argument has been changed. It is now enabled by default, but to use PL/Python the extension needs to be added explicitly with `postgresql.withPackages`. If you were using `postgresql.override { pythonSupport = true; }` before, change it to `postgresql.withPackages (ps: [ ps.plpython3 ])`. The same applies to `perlSupport`/`plperl` and `tclSupport`/`pltcl` respectively.

- Rust packages will need to regenerate their `cargoHash`.
  Cargo 1.84.0 changed the format of `cargo vendor` output, which invalidated all existing `rustPlatform.fetchCargoTarball` hashes.
  To preserve Nix’s invariants, it has been replaced with `rustPlatform.fetchCargoVendor`, an independent implementation prioritizing format stability.
  `rustPlatform.buildRustPackage` now uses `rustPlatform.fetchCargoVendor` by default; a hash mismatch error is expected in third‐party Rust packages when updating to Nixpkgs 25.05.
  Packages wishing to maintain compatibility with Nixpkgs 24.11 must explicitly set `useFetchCargoVendor` to `true`.
  `rustPlatform.importCargoLock` may also be appropriate in some circumstances.

- `cassandra_3_0` and `cassandra_3_11` have been removed as they have reached end-of-life. Please update to `cassandra_4`. See the [changelog](https://github.com/apache/cassandra/blob/cassandra-4.0.17/NEWS.txt) for more information about the upgrade process.

- `mariadb_105` has been removed as it has reached end-of-life in 2025-06. Please update to `mariadb_106`.

- NetBox was updated to `>= 4.2.0`. Have a look at the breaking changes
  of the [4.1 release](https://github.com/netbox-community/netbox/releases/tag/v4.1.0)
  and the [4.2 release](https://github.com/netbox-community/netbox/releases/tag/v4.2.0),
  make the required changes to your database, if needed, then upgrade by setting `services.netbox.package = pkgs.netbox_4_2;` in your configuration.

- `nodePackages.expo-cli` has been removed, as it was deprecated by upstream. The suggested replacement is the `npx expo` command.

- The `conduwuit` matrix server implementation has officially been discontinued by upstream and the package has thus been marked as vulnerable, as it is a security-sensitive package that has reached EOL.

- NetBox version 4.0.X available as `netbox_4_0` was removed. Please upgrade to `4.2`.

- `golangci-lint` has reached `v2`. Please read the changes and view the migration guide [here](https://golangci-lint.run/product/changelog/#200).

- `i3status-rust`-package no longer enables `notmuch` by default. It can be enabled via `withNotmuch`.

- `ocis-bin` has been renamed to `ocis_5-bin`. Future versions will have the major version suffix.

- All support for 32‐bit Darwin systems has been dropped.

- `substituteAll` and `substituteAllFiles` have been deprecated in favor of `replaceVars` and will be removed in the next release.

- Default ICU version updated from 74 to 76

- The packages `signald`, `signaldctl` and `purple-signald` have been dropped as they are unmaintained upstream and have been incompatible with the official Signal servers for a long while.

- Apache Kafka was updated to `>= 4.0.0`. Please note that this is the first release which operates
  entirely without Apache ZooKeeper support, and all clusters need to be migrated to KRaft mode. See
  the [release announcement](https://kafka.apache.org/blog#apache_kafka_400_release_announcement)
  for more details.

- `ast-grep` removes the `sg` command to prevent conflict with the `sg` command from shadow-utils. If you need legacy sg command compatibility with old code, you can use `ast-grep.override { enableLegacySg = true; }`

- rename package `wtf` to `wtfutil`.

- `python3Packages.beancount` was updated to 3.1.0. Previous major version remains available as `python3Packages.beancount_2`.

- `wastebin` has been updated to 3.0.0. See the [Changelog](https://github.com/matze/wastebin/blob/master/CHANGELOG.md#300) for breaking changes to the configuration.

- `binwalk` was updated to 3.1.0, which has been rewritten in Rust. The Python module is no longer available.
  See the release notes of [3.1.0](https://github.com/ReFirmLabs/binwalk/releases/tag/v3.1.0) for more information.

- `pkgs.nextcloud28` and `pkgs.nextcloud29` have been removed since they are out of support upstream.

- `centrifugo` was updated to v6, which uses a new config format. See [upstream documentation](https://centrifugal.dev/docs/getting-started/migration_v6) for migration.

- `teleport` has been upgraded from major version 16 to major version 17.
  Refer to [upstream upgrade instructions](https://goteleport.com/docs/upgrading/overview/)
  and [release notes for v17](https://goteleport.com/docs/changelog/#1701-11152024).

- Emacs lisp build helpers, such as `emacs.pkgs.melpaBuild`, now enables `__structuredAttrs` by default.
  Environment variables have to be passed via the `env` attribute.

- `buildGoModule` now passes environment variables via the `env` attribute. `CGO_ENABLED` should now be specified with `env.CGO_ENABLED` when passing to buildGoModule. Direct specification of `CGO_ENABLED` is now redirected by a compatibility layer with a warning, but will become an error in future releases.

  Go-related environment variables previously shadowed by `buildGoModule` now results in errors when specified directly. Such variables include `GOOS` and `GOARCH`.

  Third-party projects supporting both stable and unstable channels could detect this change through the absence of the `CGO_ENABLED` function argument in `buildGoModule` (`!((lib.functionArgs buildGoModule) ? CGO_ENABLED)`).

- `buildGoPackage` has been removed. Use `buildGoModule` instead. See the [Go section in the nixpkgs manual](https://nixos.org/manual/nixpkgs/unstable/#sec-language-go) for details.

- `buildGoModule` now supports a `goSum` attribute (`null` by default) to optionally provide a path to `go.sum` and correctly enabling rebuilds when the file changes.

- The newly added aliases `go_latest` and `buildGoLatestModule` are now available and can be use to prevent packages like `gopls` from breaking whenever the default toolchain minor version is lagging behind.
  It can also be used _outside of Nixpkgs_ to get fast access to new Go minor versions without having to wait for a staging cycle that will update the default builder/toolchain.

- A [policy documenting the details of Go toolchain and builder upgrades](https://github.com/NixOS/nixpkgs/blob/master/pkgs/build-support/go/README.md#go-toolchainbuilder-upgrade-policy) in Nixpkgs, as well as rules related to using non-default builders like `buildGo1xxModule` and `buildGoLatestModule` has been added in-tree.

- top-level `playwright` now refers to the github Microsoft/playwright package
  instead of the python tester launcher. You can still refer to the python
  launcher via `python3Packages.toPythonApplication python3Packages.playwright`

- The representation of the flags attributes as shell/environment variables for most Python building setup hooks are now the same as `stdenv.mkDerivation` and other build helpers -- they are space-separated environment variables when `__structuredAttrs = false` and Bash arrays when `__structuredAttrs = true`, and are concatenated to the command without Bash-evaluation. The following behaviour changes are introduced during the conversion:

  - The following flags are no longer Bash-expanded before concatenated to the command:
    - `disabledTests` and `disabledTestPaths` for `pytestCheckHook`. (`disabledTestPaths` used to be expanded twice before concatenation.)
    - `setupPyBuildFlags` and `setupPyGlobalFlags` for `setuptoolsBuildHook`.

  - `pytestFlags` and `unittestFlags` replace `pytestFlagsArray` and `unittestFlagsArray` and become the new and conforming interface.

  - `pytestFlagsArray` and `unittestFlagsArray` are kept for compatibility purposes. They continue to be Bash-expanded before concatenated. This compatibility layer will be removed in future releases.

- The `haka` package and module has been removed because the package was broken and unmaintained for 9 years.

- The `gsignond` package, plugins and module have been removed because they were unmaintained for 6 years.

- `strawberry` has been updated to 1.2, which drops support for the VLC backend and Qt 5. The `strawberry-qt5` package
  and `withGstreamer`/`withVlc` override options have been removed due to this.

- `nexusmods-app` has been upgraded from version 0.6.3. If you were running a version older than 0.7.0, then before upgrading, you **must reset all app state** (mods, games, settings, etc). Otherwise, NexusMods.App will crash due to app state files incompatibility.
  - Typically, you can can reset to a clean state by running `NexusMods.App uninstall-app`. See Nexus Mod's [how to uninstall the app](https://nexus-mods.github.io/NexusMods.App/users/Uninstall) documentation for more detail and alternative methods.
  - This should not be necessary going forward, because loading app state from 0.7.0 or newer is now supported. This is documented in the [0.7.1 changelog](https://github.com/Nexus-Mods/NexusMods.App/releases/tag/v0.7.1).

- `nezha` and its agent `nezha-agent` have been updated to v1, which contains breaking changes. See the [official wiki](https://nezha.wiki/en_US/) for more details.

- `ps3-disc-dumper` was updated to 4.2.5, which removed the CLI project and now exclusively offers the GUI

- `kmonad` is now hardened by default using common `systemd` settings.
  If KMonad is used to execute shell commands, hardening may make some of them fail.  In that case, you can disable hardening using the {option}`services.kmonad.keyboards.<name>.enableHardening` option.

- `isd` was updated from 0.2.0 to 0.5.1, the new version may crash with a previously generated config, try moving or deleting `~/.config/isd/schema.json`.

- `uwsgi` no longer supports Python 2 plugins.

- Support for CUDA 10 has been dropped, as announced in the 24.11 release notes.

- `mepo` was updated to version 1.3.3.  The manual page was removed,
  a new JSON API was introduced to replace Mepolang for configuration,
  and a few default key bindings were changed.
  See the [1.3.0 changelog](https://git.sr.ht/~mil/mepo/refs/1.3.0)
  for more details.

- `mkBinaryCache` now defaults to using `zstd` compression for the binary caches it creates. The previous `xz` compression method can be used by passing `compression = "xz";`.

- `nodejs_latest` was updated from 23.x to 24.x. `nodejs_23` has been removed in favor of `nodejs_24`.

- `nodejs_18` package was removed due to upstream End-of-Life in April 2025.

- `nodePackages."@commitlint/config-conventional"` has been removed, as it is a library, and projects should depend on it instead.

-  zigbee2mqtt is now available in version 2.x as `zigbee2mqtt_2`. In NixOS 25.11 we'll remove `zigbee2mqtt_1` and default to `zigbee2mqtt_2`. See the [breaking changes](https://github.com/Koenkk/zigbee2mqtt/discussions/24198) announcement for 2.0.0.

- `nodePackages.vls` has been deprecated, as the upstream consumer of it, vetur, has been deprecated by upstream. Upstream suggests migrating to Volar for Vue LSP tooling instead.

- `nodePackages.create-react-native-app` has been removed, as it is deprecated. Upstream suggests using a framework for React Native apps instead.

- `nodePackages.insect` has been removed, as it's deprecated by upstream. The suggested replacement is `numbat`.

- `nodePackages.webpack-dev-server` has been removed, as it should be installed in projects that use it instead.

- `nodePackages.copy-webpack-plugin` has been removed, as it should be installed in projects that use it instead.

- `himalaya` has been updated from `v1.0.0-beta.4` to `v1.1.0`, which introduces breaking changes. Check out the [release notes](https://github.com/pimalaya/himalaya/releases) for details.

- `linuxPackages.nvidiaPackages.dc_520` has been removed since it is marked broken and there are better newer alternatives.

- `pnpm` was updated to version 10. If your project is incompatible, you can install the previous version from the package attribute `pnpm_9`.

- `dwarf-fortress-packages` now only contains one minor version for each major version since version 0.44. Saves should still be compatible, but you may have to change which minor version you were using if it was one other than the newest.

- `tpm2-pkcs11` now is compiled without `abrmd` (Access Broker and Resource Manager Daemon) support by default, preferring the kernel resource manager. Use `tpm2-pkcs11.abrmd` if you would like a version with `abrmd` support. Note that the NixOS module picks the correct one automatically based on `security.tpm2.abrmd`.

- `zig_0_9` and `zig_0_10` have been removed, you should upgrade to `zig_0_13` (also available as just `zig`), `zig_0_12` or `zig_0_11` instead.

- `webpack-cli` was updated to major version 6, which has breaking changes from the previous version 5.1.4. See the [upstream release notes](https://github.com/webpack/webpack-cli/releases/tag/webpack-cli%406.0.0) for details on these changes.

- `minetest` has been renamed to `luanti` to match the upstream name change but aliases have been added. The new name hasn't resulted in many changes as of yet but older references to minetest should be sunset. See the [new name announcement](https://blog.minetest.net/2024/10/13/Introducing-Our-New-Name/) for more details.

- `poac` has been renamed to `cabinpkg` to match the upstream name change but an alias has been added. See the [new name announcement](https://github.com/orgs/cabinpkg/discussions/1052) for more details.

- `serious-sans` has been removed because upstream changed its name to Serious Shanns, which is not currently packaged.

- `racket_7_9` has been removed, as it is insecure. It is recommended to use Racket 8 instead.

- `rofi` has been updated from 1.7.5 to 1.7.6 which introduces some breaking changes to binary plugins, and also contains a lot of new features and bug fixes. This is highlighted because the patch version bump does not indicate the volume of changes by itself. See the [upstream release notes](https://github.com/davatorium/rofi/releases/tag/1.7.6) for the full list of changes.

- `ente-auth` now uses the name `enteauth` for its binary. The previous name was `ente_auth`.

- `foundationdb` was upgraded to 7.3.

- `fluxus` has been removed, as it depends on `racket_7_9` and had no updates in 9 years.

- `meilisearch` has been upgraded from 1.11.3 to 1.14.0, which requires manually dumping and importing the data.
  See Meilisearch's [upgrade guide](https://www.meilisearch.com/docs/learn/update_and_migration/updating) for more information.

- `sm64ex-coop` has been removed as it was archived upstream. Consider migrating to `sm64coopdx`.

- `tldr` now uses [`tldr-python-client`](https://github.com/tldr-pages/tldr-python-client) instead of [`tldr-c-client`](https://github.com/tldr-pages/tldr-c-client) which is unmaintained.

- The behavior of the `networking.nat.externalIP` and `networking.nat.externalIPv6` options has been changed. `networking.nat.forwardPorts` now only forwards packets destined for the specified IP addresses.

- `python3Packages.bpycv` has been removed due to being incompatible with Blender 4 and unmaintained.

- `python3Packages.jaeger-client` was removed because it was deprecated upstream. [OpenTelemetry](https://opentelemetry.io) is the recommended replacement.

- `nodePackages.meshcommander` has been removed, as the package was deprecated by Intel.

- The default version of `z3` has been updated from 4.8 to 4.15, and all old versions have been dropped. Note that `fstar` still depends on specific versions, and maintains them as overrides.

- `prometheus` has been updated from 2.55.0 to 3.1.0.
  Read the [release blog post](https://prometheus.io/blog/2024/11/14/prometheus-3-0/) and
  [migration guide](https://prometheus.io/docs/prometheus/3.1/migration/).

- `kanata` was updated to v1.8.0, which introduces several breaking changes.
  See the release notes of
  [v1.7.0](https://github.com/jtroo/kanata/releases/tag/v1.7.0) and
  [v1.8.0](https://github.com/jtroo/kanata/releases/tag/v1.8.0)
  for more information.

- `authelia` version 4.39.0 has made changes on the default claims for ID Tokens, to mirror the standard claims from the specification.
  This change may affect some clients in unexpected ways, so manual intervention may be required.
  Read the [release notes](https://www.authelia.com/blog/4.39-release-notes/), along with [the guide](https://www.authelia.com/integration/openid-connect/openid-connect-1.0-claims/#restore-functionality-prior-to-claims-parameter) to work around issues that may be encountered.

- `ags` was updated to v2, which is just a CLI for Astal now. Components are available as a different package set `astal.*`.
  If you want to use v1, it is available as `ags_1` package.

  See the release notes of
  [v2.0.0](https://github.com/Aylur/ags/releases/tag/v2.0.0)
  for more information.

- `nodePackages.expo-cli` has been removed, as it was deprecated by upstream. The suggested replacement is the `npx expo` command.

- `open-policy-agent` has has been updated to 1.0.0+.
  This major release makes the `rego.v1` syntax the default.
  This is a breaking change for those using v0 Rego.
  See the [upgrade documentation](https://www.openpolicyagent.org/docs/v1.0.1/v0-upgrade/) for more details.
  For those unable to upgrade yet, there is a [v0 compatibility mode](https://www.openpolicyagent.org/docs/v1.0.1/v0-compatibility/)
  available too.

- `helmfile` was updated to v1.0.0, which introduces several breaking changes.
  See the release notes of
  [v1.0.0](https://github.com/helmfile/helmfile/releases/v1.0.0) for more
  information.

- `vscode-utils.buildVscodeExtension` now requires pname as an argument

- `nerdfonts` has been separated into individual font packages under the namespace `nerd-fonts`. The directories for font
  files have changed from `$out/share/fonts/{opentype,truetype}/NerdFonts` to
  `$out/share/fonts/{opentype,truetype}/NerdFonts/<fontDirName>`, where `<fontDirName>` can be found in the
  [official website](https://www.nerdfonts.com/font-downloads) as the titles in preview images, with the "Nerd Font"
  suffix and any whitespaces trimmed. Configuration changes are required, see build output.

- `retroarch` has been refactored and the older `retroarch.override { cores = [ ... ]; }` to create a RetroArch derivation with custom cores doesn't work anymore, use `retroarch.withCores (cores: [ ... ])` instead. If you need more customization (e.g.: custom settings), use `wrapRetroArch` instead.

- `borgmatic` has been updated from 1.8.14 to 1.9.5, please check the [upstream changelog](https://projects.torsion.org/borgmatic-collective/borgmatic/releases) for more details, especially for a few possibly breaking changes noted in the [1.9.0 changelog](https://projects.torsion.org/borgmatic-collective/borgmatic/releases/tag/1.9.0).

- `nodePackages.ganache` has been removed, as the package has been deprecated by upstream.

- `matomo` now defaults to version 5 (previously available as `matomo_5`). Version 4 has been removed as it reached EOL on December 19, 2024.

- `matomo-beta` has been removed as the version of the `matomo` package can now be easily overridden through `overrideAttrs` (see [PR #374022](https://github.com/NixOS/nixpkgs/pull/374022))

- `docker_24` has been removed, as it was EOL with vulnerabilities since June 08, 2024.

- Emacs 28 and 29 have been removed.

- Emacs 28 Macport has been removed, while CVEs of Emacs 29 Macport are patched.

- `containerd` has been updated to v2, which contains breaking changes. See the [containerd
  2.0](https://github.com/containerd/containerd/blob/main/docs/containerd-2.0.md) documentation for more
  details.

- The `tinycc` package now has the `dev`, `doc` and `lib` outputs, thus,
`tinycc.out` may now only provide the tcc and cross compilers binaries.

- The `testTarget` argument of `haskellPackages.mkDerivation` has been deprecated in favour of `testTargets`.
  `testTarget` took a space separated string of targets, whereas the new `testTargets` argument takes a list of targets.
  For instance, `testTarget = "foo bar baz"` should become `testTargets = [ "foo" "bar" "baz" ]`.

- `rustPlatform.buildRustPackage` stops handling the deprecated argument `cargoSha256`. Out-of-tree packages that haven't migrated from `cargoSha256` to `cargoHash` now receive errors.

- `nodePackages.stackdriver-statsd-backend` has been removed, as the StackDriver service has been discontinued by Google, and therefore the package no longer works.

- `python3Packages.opentracing` has been removed due to being unmaintained upstream. [OpenTelemetry](https://opentelemetry.io/) is the recommended replacement.

- the notmuch vim plugin now lives in a separate output of the `notmuch`
  package. Installing `notmuch` will not bring the notmuch vim package anymore,
  add `vimPlugins.notmuch-vim` to your (Neo)vim configuration if you want the
  vim plugin.

- The fileSystems (e.g., `fileSystems."/"`) are now set by NixOS-implemented modules using `lib.mkDefault`, allowing wholesale overrides, but this means that overriding individual attributes (like `fsType` or `options`) without explicitly specifying `device` may result in missing required fields and errors such as `No device specified for mount point '/'` (https://github.com/NixOS/nixpkgs/pull/377406).

- `prisma` and `prisma-engines` have been updated to version 6.7.0, which
  introduces several breaking changes. See the
  [Prisma ORM upgrade guide](https://www.prisma.io/docs/orm/more/upgrade-guides/upgrading-versions/upgrading-to-prisma-6)
  for more information.

- `dependency-track` no longer bundles the UI inside the jar. This bundling
  functionality is deprecated by upstream and causes UI assets not being served
  after weeks of runtime.

- `nq` was updated to 1.0, which renames the `fq` and `tq` utilities to `nqtail` and `nqterm` respectively.

- `zf` was updated to 0.10.2, which includes breaking changes from the [0.10.0 release](https://github.com/natecraddock/zf/releases/tag/0.10.0).
  `zf` no longer does Unicode normalization of the input and no longer supports terminal escape sequences in the `ZF_PROMPT` environment variable.

- `confluent-cli` was updated from 3.60.0 to 4.16.0, which includes several breaking changes as detailed in [Confluent's release notes](https://docs.confluent.io/confluent-cli/current/release-notes.html).

- `siduck76-st` has been renamed to `st-snazzy`, like the project's [flake](https://github.com/siduck/st/blob/main/flake.nix). An alias for the old name has been added.

- `python3Packages.jax` now directly depends on `python3Packages.jaxlib`.
  As a result, packages that depend on jax no longer need to include jaxlib to their dependencies.
  There is also a breaking change in the handling of CUDA. Instead of using a CUDA-compatible jaxlib
  as before, you can use plugins like `python3Packages.jax-cuda12-plugin`.

- Added `allowVariants` to gate availability of package sets like `pkgsLLVM`, `pkgsMusl`, `pkgsZig`, etc. This was done in an effort to
  decrease evaluation times by limiting the number of instances of nixpkgs to evaluate. The option will be removed in the future as a
  new mechanism is in the works for handling cross compilation.

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

## Other Notable Changes {#sec-nixpkgs-release-25.05-notable-changes}

- `i18n` module improvements:
  - `i18n.extraLocales` should now be the preferred way to install additional locales.
  - `i18n.supportedLocales` is now considered an implementation detail and will be hidden from the documentation. But the option will still continue to work.
  - `i18n.supportedLocales` will now trigger a warning when it omits any locale set in `i18n.defaultLocale`, `i18n.extraLocales` or `i18n.extraLocaleSettings`.
  - The options `i18n.defaultCharset` & `i18n.localeCharsets` were added, and they complement `i18n.defaultLocale` & `i18n.extraLocaleSettings` respectively - allowing to control the character set used per locale setting.

- Plasma 5 and Qt 5 based versions of associated software are deprecated in NixOS 25.05, and will be removed in NixOS 25.11. Users are encouraged to upgrade to Plasma 6.

- `titaniumenv`, `titanium`, and `titanium-alloy` have been removed due to lack of maintenance in Nixpkgs []{#sec-nixpkgs-release-25.05-incompatibilities-titanium-removed}.

- [Cursor](https://cursor.com/) — a vscode-based editor that uses AI to help you write code faster — has been packaged as `cursor`.

- `octave` (and `octaveFull`) was updated to version `10.x`. The update broke a few `octavePackages`, and `librsb`. See [the PR's commits](https://github.com/NixOS/nixpkgs/pull/394495/commits) for more details.

- androidenv has been improved:
  - All versions specified in composeAndroidPackages now track the latest. Android packages are automatically updated on unstable, and run the androidenv test suite on every update.
  - Many androidenv packages are now searchable on [search.nixos.org](https://search.nixos.org).
  - We now use the latest Google repositories, which should improve aarch64-darwin compatibility. The SDK now additionally evaluates on aarch64-linux, though not all packages are functional.

- `dwarf-fortress` audio now works again. Additionally, the `dfhack` and `dwarf-fortress-full` packages are now exposed at toplevel, making it easier to install and play Dwarf Fortress. Note that `dwarf-fortress-full` is the Nixpkgs equivalent of the Dwarf Fortress Lazy Pack.

- `gerbera` now has wavpack support.

- `buildPythonPackage`, `buildPythonApplication` and the Python building setup hooks now support both `__structuredAttrs = true` and `__structuredAttrs = false`.

- `buildGoModule` now supports a self-referencing `finalAttrs:` parameter
  containing the final arguments including overrides.
  This allows packaging configuration to be overridden in a consistent manner by
  providing an alternative to `rec {}` syntax.

- Caddy can now be built with plugins by using `caddy.withPlugins`, a `passthru` function that accepts an attribute set as a parameter. The `plugins` argument represents a list of Caddy plugins, with each Caddy plugin being a versioned module. The `hash` argument represents the `vendorHash` of the resulting Caddy source code with the plugins added.

  Example:
  ```nix
  let
    pkgs = import <nixpkgs> { };

  in
  pkgs.caddy.withPlugins {
    plugins = [
      # tagged upstream
      "github.com/caddy-dns/powerdns@v1.0.1"
      # pseudo-version number generated by Go
      "github.com/caddy-dns/cloudflare@v0.0.0-20240703190432-89f16b99c18e"
      "github.com/mholt/caddy-webdav@v0.0.0-20241008162340-42168ba04c9d"
    ];
    hash = "sha256-wqXSd1Ep9TVpQi570TTb96LwzNYvWL5EBJXMJfYWCAk=";
  }
  ```

  To get the necessary hash of the vendored dependencies, omit `hash`. The build will fail and tell you the correct value.

  Note that all provided plugins must have versions/tags (string after `@`), even if upstream repo does not tag each release. For untagged plugins, you can either create an empty Go project and run `go get <plugin>` and see changes in `go.mod` to get the pseudo-version number, or provide a commit hash in place of version/tag for the first run, and update the plugin string based on the error output.

- The `godot-export-templates` package now has its content at `share/godot/export_templates/$version` instead of the output root. This makes it more convenient for for symlinking into `~/.local`, but scripts expecting the old layout will need to be changed.

- GOverlay has been updated to 1.2, please check the [upstream changelog](https://github.com/benjamimgois/goverlay/releases) for more details.

- `tpm2-pkcs11` now has the variant `tpm2-pkcs11-fapi`, which has been patched to default to the Feature API backend. It has also been split into `tpm2-pkcs11-esapi`, which _only_ supports the older Enhanced System API backend. Note the [differences](https://github.com/tpm2-software/tpm2-pkcs11/blob/1.9.1/docs/FAPI.md), and that `tpm2-pkcs11` itself still needs `TPM2_PKCS11_BACKEND=fapi` exported in order to use the Feature API, whereas `tpm2-pkcs11-fapi` does not, and `tpm2-pkcs11-esapi` just does not support fapi entirely.

- For matrix homeserver Synapse we are now following the upstream recommendation to enable jemalloc as the memory allocator by default.

- Mattermost, a self-hosted chat collaboration platform supporting calls, playbooks, and boards, has been updated. It now has multiple versions, disabled telemetry, and a native frontend build in nixpkgs, removing all upstream prebuilt blobs.
  - A new `pkgs.mattermost.buildPlugin` function has been added, which allows plugins to be built from source, including webapp frontends with a supported package-lock.json. See the Mattermost NixOS test and [manual](https://nixos.org/manual/nixos/unstable#sec-mattermost-plugins-build) for an example.
  - The Mattermost frontend is now built from source and can be overridden. Note that the Mattermost derivation containing both the webapp and server is now wrapped to allow them to be built independently, so overrides to both webapp and server look like `mattermost.overrideAttrs (prev: { webapp = prev.webapp.override { ... }; server = prev.server.override { ... }; })` now.
  - `pkgs.mattermost` has been updated from 9.11 to 10.5 to track the latest extended support release, since 9.11 will become end-of-life during the lifetime of NixOS 25.05.
  - `pkgs.mattermostLatest` is now an option to track the latest (non-prerelease) Mattermost release. We test upgrade migrations from ESR releases (`pkgs.mattermost`) to `pkgs.mattermostLatest`.

- A new hardening flag, `nostrictaliasing` was made available, corresponding to the gcc/clang option `-fno-strict-aliasing`.

- The `stackclashprotection` hardening flag has been enabled by default on compilers that support it.

- In `dovecot` package, the hardcoded path to the module directory has been removed.

- `authelia` version 4.39.0 has made some changes which deprecate older configurations.
  They are still expected to be working until future version 5.0.0, but will generate warnings in logs.
  Read the [release notes](https://www.authelia.com/blog/4.39-release-notes/) for human readable summaries of the changes.

- `hddfancontrol` has been updated to major release 2. See the [migration guide](https://github.com/desbma/hddfancontrol/tree/master?tab=readme-ov-file#migrating-from-v1x), as there are breaking changes.

- `nextcloud-news-updater` is unmaintained and was removed from Nixpkgs.

- KDE Partition Manager `partitionmanager`'s support for ReiserFS is removed.
  ReiserFS has not been actively maintained for many years. It has been marked as obsolete since Linux 6.6, and
  [is removed](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=c01f664e4ca210823b7594b50669bbd9b0a3c3b0)
  in Linux 6.13.

- `gerbera` now has wavpack support.

- `signal-desktop` has been migrated to a from source build. No state migration is necessary. In case there's no working source build available (like on Darwin), the the binary build is still available at `signal-desktop-bin`.

- `ddclient` was updated from 3.11.2 to 4.0.0 [Release notes](https://github.com/ddclient/ddclient/releases/tag/v4.0.0)

## Nixpkgs Library {#sec-nixpkgs-release-25.05-lib}

### Breaking changes {#sec-nixpkgs-release-25.05-lib-breaking}

- Structure of the `functor` of some types has changed. `functor` is an implementation detail and should not be relied upon. If you did rely on it let us know in this [PR](https://github.com/NixOS/nixpkgs/pull/363565).
  - [`lib.types.enum`](https://nixos.org/manual/nixos/unstable/#sec-option-types-basic): Previously the `functor.payload` was the list of enum values directly. Now it is an attribute set containing the values in the `values` attribute.
  - [`lib.types.separatedString`](https://nixos.org/manual/nixos/unstable/#sec-option-types-string): Previously the `functor.payload` was the separator directly. Now it is an attribute set containing the separator in the `sep` attribute.

- [`lib.packagesFromDirectoryRecursive`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.filesystem.packagesFromDirectoryRecursive) now rejects unknown arguments.

### Deprecations {#sec-nixpkgs-release-25.05-lib-deprecations}

- `functor` is an implementation detail and should not be relied upon, but since its status wasn't clear and it has had some use cases without alternatives, changes are being handled as gracefully as possible. Deprecations within functor:
  - `functor.wrapped` is now deprecated for some types and using it will give a warning with migration instructions. It is deprecated for these types:
    - `lib.types.attrsWith`
    - `lib.types.listOf`
    - `lib.types.unique` and `lib.types.uniq`
    - `lib.types.nullOr`
    - `lib.types.functionTo`
    - `lib.types.coercedTo`
    - `lib.types.either`

### Additions and Improvements {#sec-nixpkgs-release-25.05-lib-additions-improvements}

- [`lib.packagesFromDirectoryRecursive`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.filesystem.packagesFromDirectoryRecursive) can now construct nested scopes matching the directory tree passed as input.
