#!/usr/bin/env nix-shell
#!nix-shell -i bash -p nix curl cacert

set -euo pipefail

export SSL_CERT_FILE=$NIX_SSL_CERT_FILE

readonly SECURITY_KEY="7f8faaaa468174dc1c9cd62e5f218a5b"
prefix="https://wps-linux-personal.wpscdn.cn"

payload=$(curl -s "https://www.wps.cn/product/wpslinux")

version=$(echo "$payload" | grep -oP '(?<=banner_txt">)[^<]+')

amd64_url=$(echo "$payload" | grep -oP "downLoad\('[^']*'" | head -1 | sed "s/downLoad('//;s/'$//")

timestamp10=$(date '+%s')
amd64_md5hash=($(printf '%s' "$SECURITY_KEY${amd64_url#$prefix}$timestamp10" | md5sum))

amd64_hash=$(nix-prefetch-url --name "wpsoffice-cn-$version.deb" "$amd64_url?t=$timestamp10&k=$amd64_md5hash")

amd64_hash=$(nix --extra-experimental-features nix-command hash convert --to sri --hash-algo sha256 "$amd64_hash")

cat > sources.nix << EOF
# Generated by ./update.sh - do not update manually!
# Last updated: $(date +%F)
{
  version = "$version";
  x86_64 = {
    url = "$amd64_url";
    hash = "$amd64_hash";
  };
}
EOF
