{
  lib,
  u-root,
  which,
}:

u-root.overrideAttrs (prevAttrs: {
  subPackages = [
    "cmds/boot/boot"
    "cmds/boot/fitboot"
    "cmds/boot/pxeboot"
    "cmds/cluster/nodestats"
    "cmds/contrib/fbptcat"
    "cmds/core/backoff"
    "cmds/core/base64"
    "cmds/core/basename"
    "cmds/core/blkid"
    "cmds/core/brctl"
    "cmds/core/cat"
    "cmds/core/chmod"
    "cmds/core/chroot"
    "cmds/core/cmp"
    "cmds/core/comm"
    "cmds/core/cp"
    "cmds/core/cpio"
    "cmds/core/date"
    "cmds/core/dd"
    "cmds/core/df"
    "cmds/core/dhclient"
    "cmds/core/dirname"
    "cmds/core/dmesg"
    "cmds/core/du"
    "cmds/core/echo"
    "cmds/core/false"
    "cmds/core/find"
    "cmds/core/free"
    "cmds/core/fusermount"
    "cmds/core/gosh"
    "cmds/core/gpgv"
    "cmds/core/gpt"
    "cmds/core/grep"
    "cmds/core/gzip"
    "cmds/core/head"
    "cmds/core/hexdump"
    "cmds/core/hostname"
    "cmds/core/hwclock"
    "cmds/core/id"
    "cmds/core/init"
    "cmds/core/insmod"
    "cmds/core/io"
    "cmds/core/ip"
    "cmds/core/kexec"
    "cmds/core/kill"
    "cmds/core/lddfiles"
    "cmds/core/ln"
    "cmds/core/lockmsrs"
    "cmds/core/losetup"
    "cmds/core/ls"
    "cmds/core/lsdrivers"
    "cmds/core/lsmod"
    "cmds/core/man"
    "cmds/core/md5sum"
    "cmds/core/mkdir"
    "cmds/core/mkfifo"
    "cmds/core/mknod"
    "cmds/core/mktemp"
    "cmds/core/more"
    "cmds/core/mount"
    "cmds/core/msr"
    "cmds/core/mv"
    "cmds/core/netcat"
    "cmds/core/netstat"
    "cmds/core/nohup"
    "cmds/core/ntpdate"
    "cmds/core/pci"
    "cmds/core/ping"
    "cmds/core/poweroff"
    "cmds/core/printenv"
    "cmds/core/ps"
    "cmds/core/pwd"
    "cmds/core/readlink"
    "cmds/core/realpath"
    "cmds/core/rm"
    "cmds/core/rmmod"
    "cmds/core/rsdp"
    "cmds/core/scp"
    "cmds/core/seq"
    "cmds/core/shasum"
    "cmds/core/shutdown"
    "cmds/core/sleep"
    "cmds/core/sluinit"
    "cmds/core/sort"
    "cmds/core/sshd"
    "cmds/core/strace"
    "cmds/core/strings"
    "cmds/core/stty"
    "cmds/core/switch_root"
    "cmds/core/sync"
    "cmds/core/tail"
    "cmds/core/tar"
    "cmds/core/tee"
    "cmds/core/time"
    "cmds/core/timeout"
    "cmds/core/touch"
    "cmds/core/tr"
    "cmds/core/true"
    "cmds/core/truncate"
    "cmds/core/ts"
    "cmds/core/tty"
    "cmds/core/umount"
    "cmds/core/uname"
    "cmds/core/uniq"
    "cmds/core/unmount"
    "cmds/core/unshare"
    "cmds/core/uptime"
    "cmds/core/watchdog"
    "cmds/core/watchdogd"
    "cmds/core/wc"
    "cmds/core/wget"
    "cmds/core/which"
    "cmds/core/xargs"
    "cmds/core/yes"
    "cmds/exp/acpicat"
    "cmds/exp/acpigrep"
    "cmds/exp/ansi"
    "cmds/exp/bootvars"
    "cmds/exp/bzimage"
    "cmds/exp/cbmem"
    "cmds/exp/console"
    "cmds/exp/crc"
    "cmds/exp/disk_unlock"
    "cmds/exp/dmidecode"
    "cmds/exp/dumpebda"
    "cmds/exp/dumpmemmap"
    "cmds/exp/ectool"
    "cmds/exp/ed"
    "cmds/exp/efivarfs"
    "cmds/exp/esxiboot"
    "cmds/exp/fbnetboot"
    "cmds/exp/fbsplash"
    "cmds/exp/fdtdump"
    "cmds/exp/field"
    "cmds/exp/fixrsdp"
    "cmds/exp/forth"
    "cmds/exp/freq"
    "cmds/exp/getty"
    "cmds/exp/hdparm"
    "cmds/exp/ipmidump"
    "cmds/exp/kconf"
    "cmds/exp/localboot"
    "cmds/exp/lsfabric"
    "cmds/exp/madeye"
    "cmds/exp/modprobe"
    "cmds/exp/netbootxyz"
    "cmds/exp/newsshd"
    "cmds/exp/nvme_unlock"
    "cmds/exp/page"
    "cmds/exp/partprobe"
    "cmds/exp/pflask"
    "cmds/exp/pox"
    "cmds/exp/pxeserver"
    "cmds/exp/readelf"
    "cmds/exp/readpe"
    "cmds/exp/run"
    "cmds/exp/rush"
    "cmds/exp/smbios_transfer"
    "cmds/exp/smn"
    "cmds/exp/srvfiles"
    "cmds/exp/ssh"
    "cmds/exp/syscallfilter"
    "cmds/exp/systemboot"
    "cmds/exp/tac"
    "cmds/exp/tc"
    "cmds/exp/tcpdump"
    "cmds/exp/tcz"
    "cmds/exp/tftp"
    "cmds/exp/traceroute"
    "cmds/exp/uefiboot"
    "cmds/exp/vboot"
    "cmds/exp/vmboot"
    "cmds/exp/watch"
    "cmds/exp/zbi"
    "cmds/exp/zimage"
    "cmds/extra/tsort"
    "cmds/fwtools/flash"
    "cmds/fwtools/spidev"
  ];

  allowGoReference = false;

  nativeCheckInputs = [ which ];

  preCheck = ''
    rm cmds/core/brctl/*_test.go # Error: open /sys/class/net: no such file or directory
    rm cmds/core/du/*_test.go # Error: expected 0 got 8
    rm cmds/core/mkdir/*_test.go # Error: Mode = 'drwxr-xr-x', want: 'dgrwxrwxrwx'
    rm cmds/core/netcat/*_test.go # Error: parseRemoteAddr(tcp, ::1) = [::1 localhost], want a subset of [::1 ip6-localhost]
    rm cmds/exp/bzimage/*_test.go # Error: compressed KernelCode too big: was 611116, now 611124
  '';

  meta = (lib.removeAttrs prevAttrs.meta [ "mainProgram" ]) // {
    longDescription = "All u-root commands compiles as standalone binaries";
  };
})
