#! /usr/bin/env nix-shell
#! nix-shell -i bash --pure --keep GITHUB_TOKEN -p nix git curl cacert nix-prefetch-git gnugrep

base_url=$(curl -Ls -o /dev/null -w %{url_effective} https://todoist.com/linux_app/appimage)
version=$(echo $base_url | grep -oP '(?<=Todoist-linux-)(\d+\.\d+\.\d+)')

url=()
hash=()

for i in x86_64 arm64
do
    current_url=$(echo $base_url | sed "s/x86_64/$i/")
    url+=($current_url)
    hash+=("$(nix --extra-experimental-features nix-command hash convert --hash-algo sha256 --to sri $(nix-prefetch-url $current_url))")
done

cat >sources.nix <<EOF
# Generated by ./update.sh - do not update manually!
# Last updated: $(date +%F)
{
  version = "$version";
  x86_64-linux = {
    url = "${url[0]}";
    hash = "${hash[0]}";
  };
  aarch64-linux = {
    url = "${url[1]}";
    hash = "${hash[1]}";
  };
}
EOF
