{
  lib,
  rustPlatform,
  fetchFromSourcehut,
  versionCheckHook,
  nix-update-script,
}:

rustPlatform.buildRustPackage (finalAttrs: {
  pname = "rusty-man";
  version = "0.5.0";

  src = fetchFromSourcehut {
    owner = "~ireas";
    repo = "rusty-man";
    rev = "v${finalAttrs.version}";
    hash = "sha256-djprzmogT1OEf0/+twdxzx30YaMNzFjXkZd4IDsH8oo=";
  };

  cargoHash = "sha256-ZIRwp5AJugMDxg3DyFIH5VlD0m4Si2tJdspKE5QEB4M=";

  nativeInstallCheckInputs = [ versionCheckHook ];
  versionCheckProgramArg = "--version";
  doInstallCheck = true;

  passthru.updateScript = nix-update-script { };

  meta = {
    description = "Command-line viewer for documentation generated by rustdoc";
    mainProgram = "rusty-man";
    homepage = "https://git.sr.ht/~ireas/rusty-man";
    changelog = "https://git.sr.ht/~ireas/rusty-man/tree/v${finalAttrs.version}/item/CHANGELOG.md";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [
      defelo
    ];
  };
})
