{
  stdenv,
  lib,
  nixosTests,
  fetchFromGitHub,
  pihole,
  pihole-ftl,
  procps,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "pihole-web";
  version = "6.2.1";

  src = fetchFromGitHub {
    owner = "pi-hole";
    repo = "web";
    tag = "v${finalAttrs.version}";
    hash = "sha256-pfKWOb+DJSRy9r2igx8voRpAPHKshVqYMoxOwoBWZLA=";
  };

  propagatedBuildInputs = [
    pihole
    pihole-ftl
    procps
  ];

  installPhase = ''
    runHook preInstall

    mkdir -p $out/share
    cp -r -t $out/share *.lp img/ scripts/ style/ vendor/

    mkdir -p $out/share/doc/$name/
    cp README.md $out/share/doc/$name/

    runHook postInstall
  '';

  passthru.tests = nixosTests.pihole-ftl;

  meta = {
    description = "Pi-hole web dashboard displaying stats and more";
    homepage = "https://github.com/pi-hole/web";
    changelog = "https://github.com/pi-hole/FTL/releases/tag/v${finalAttrs.version}";
    longDescription = ''
      Pi-hole's Web interface (based off of AdminLTE) provides a central
      location to manage your Pi-hole and review the statistics generated by
      FTLDNS.
    '';
    license = lib.licenses.eupl12;
    maintainers = with lib.maintainers; [ averyvigolo ];
    platforms = lib.platforms.linux;
  };
})
