{
  lib,
  stdenvNoCC,
  fetchFromGitHub,
}:

stdenvNoCC.mkDerivation {
  pname = "linux-exploit-suggester";
  version = "unstable-2022-04-01";

  src = fetchFromGitHub {
    owner = "mzet-";
    repo = "linux-exploit-suggester";
    rev = "54a5c01497d6655be88f6262ccad5bc5a5e4f4ec";
    sha256 = "v0Q8O+aaXEqwWAwGP/u5Nkm4DzM6nM11GI4XbK2PeWM=";
  };

  installPhase = ''
    runHook preInstall

    install -Dm755 linux-exploit-suggester.sh $out/bin/linux-exploit-suggester

    runHook postInstall
  '';

  meta = with lib; {
    description = "Tool designed to assist in detecting security deficiencies for given Linux kernel/Linux-based machine";
    mainProgram = "linux-exploit-suggester";
    homepage = "https://github.com/mzet-/linux-exploit-suggester";
    license = licenses.gpl3Only;
    maintainers = with maintainers; [ emilytrau ];
    platforms = platforms.linux;
  };
}
