{
  fetchFromGitHub,
  lib,
  stdenv,
  cmake,
}:

stdenv.mkDerivation rec {
  pname = "libupnp";
  version = "1.14.25";

  outputs = [
    "out"
    "dev"
  ];

  src = fetchFromGitHub {
    owner = "pupnp";
    repo = "pupnp";
    tag = "release-${version}";
    hash = "sha256-emMZKskaFYmLnIZLduHlZ5I3praaBgXY2JHLDAGPO28=";
  };

  nativeBuildInputs = [
    cmake
  ];

  postPatch = ''
    # Wrong paths in pkg-config file generated by CMake
    # https://github.com/pupnp/pupnp/pull/205/files#r588946478
    substituteInPlace CMakeLists.txt \
      --replace '\''${exec_prefix}/' "" \
      --replace '\''${prefix}/' ""
  '';

  # Fix broken cmake files
  # https://gitlab.archlinux.org/archlinux/packaging/packages/libupnp/-/commit/69a99f8ccd4c6f335db9b5842f0facde585721eb
  postFixup = ''
    sed -e 's|/COMPONENT||g' -e 's|/UPNP_Development||g' -i ${placeholder "dev"}/lib/cmake/*/*.cmake
  '';

  meta = {
    description = "Open source UPnP development kit for Linux";

    longDescription = ''
      The Linux SDK for UPnP Devices (libupnp) provides developers
      with an API and open source code for building control points,
      devices, and bridges that are compliant with Version 1.0 of the
      UPnP Device Architecture Specification.
    '';

    license = lib.licenses.bsd3;

    homepage = "https://pupnp.github.io/pupnp/";
    platforms = lib.platforms.unix;
  };
}
