{
  lib,
  buildGoModule,
  fetchFromGitHub,
}:

buildGoModule rec {
  pname = "go-exploitdb";
  version = "0.6.2";

  src = fetchFromGitHub {
    owner = "vulsio";
    repo = "go-exploitdb";
    tag = "v${version}";
    hash = "sha256-kfPM1p7ihfCRsxYjqfKbcwaM2DLdOAqQ2ywxzEQV8A4=";
  };

  vendorHash = "sha256-0RYc0ssdyV1b0DsMD5+0FA6oGStextvajX7SgHVQueU=";

  ldflags = [
    "-s"
    "-w"
    "-X=github.com/vulsio/go-exploitdb/config.Version=${version}"
  ];

  meta = {
    description = "Tool for searching Exploits from Exploit Databases, etc";
    mainProgram = "go-exploitdb";
    homepage = "https://github.com/vulsio/go-exploitdb";
    changelog = "https://github.com/vulsio/go-exploitdb/releases/tag/v${version}";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ fab ];
  };
}
