{
  lib,
  rustPlatform,
  fetchFromGitHub,
}:

rustPlatform.buildRustPackage rec {
  pname = "cargo-sweep";
  version = "0.8.0";

  src = fetchFromGitHub {
    owner = "holmgr";
    repo = "cargo-sweep";
    rev = "v${version}";
    sha256 = "sha256-/a7quBIX3gr9vVwQfDHdfkt4Xt7UYpjMNiyqivhOvBQ=";
  };

  cargoHash = "sha256-6J512mezcMn82z7qN+ppy66v4tzqMFyqDXU6H9+xyaQ=";

  checkFlags = [
    # Requires a rustup toolchain to be installed.
    "--skip check_toolchain_listing_on_multiple_projects"
    # Does not work with a `--target` build in the environment
    "--skip empty_project_output"
  ];

  meta = with lib; {
    description = "Cargo subcommand for cleaning up unused build files generated by Cargo";
    mainProgram = "cargo-sweep";
    homepage = "https://github.com/holmgr/cargo-sweep";
    license = licenses.mit;
    maintainers = with maintainers; [
      xrelkd
      matthiasbeyer
    ];
  };
}
